# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to build trust
    if current_round == 1:
        return "C"
    
    # Round 10: Always defect
    if current_round == 10:
        return "D"
    
    # Early Rounds (2-3): Cooperate to avoid triggering grim retaliation
    if 2 <= current_round <= 3:
        return "C"
    
    # Middle Rounds (4-7): Forgiving but firm approach
    if 4 <= current_round <= 7:
        if opp_history[-1] == "C":
            return "C" if random.random() < 0.9 else "D"
        else:
            return "D" if random.random() < 0.8 else "C"
    
    # Late Rounds (8-9): Grim trigger if opponent defected in rounds 1-7
    if 8 <= current_round <= 9:
        if "D" in opp_history[:7]:
            return "D"
        else:
            return "C"
    
    # Default fallback (should not reach here)
    return "C"